<?php

use Illuminate\Support\Facades\Route;
use Modules\Console\Controllers\AdminController;
use Modules\Console\Controllers\PropertyController;
use App\Http\Controllers\TestController;
//Route::get('/property-list.html', [TestController::class, 'propertyList']);
//Route::get('/property/{slug}.html', [TestController::class, 'showProperty']);

Route::prefix('console')->group(function () {
    Route::get('/', fn() => redirect('/console/admin/login'));

    Route::get('/admin/login', [AdminController::class, 'login']);
    Route::post('/admin/login', [AdminController::class, 'login']);
    Route::get('/admin/index', [AdminController::class, 'index']);

    Route::controller(PropertyController::class)->group(function() {
        Route::get('/property/list', 'list')->name('property.list');
        Route::post('/property/list', 'list');
        Route::get('/property/add', 'add')->name('property.add');
        Route::post('/property/manageData', 'manageData')->name('property.manageData');
        Route::post('/property/delete', 'delete')->name('property.delete');
        Route::post('/property/updateStatus', 'updateStatus')->name('property.updateStatus');
        Route::post('/property/manageBulkOperation', 'manageBulkOperation')->name('property.manageBulkOperation');
        Route::get('/property/getBankerData', 'getBankerData')->name('property.getBankerData');
        Route::get('/property/getCityData', 'getCityData')->name('property.getCityData');
        Route::get('/property/getLocationData', 'getLocationData')->name('property.getLocationData');
        Route::post('/property/deleteMedia', 'deleteMedia')->name('property.deleteMedia');
        Route::post('/property/deleteMultipleMedia', 'deleteMultipleMedia')->name('property.deleteMultipleMedia');
        Route::get('/property/bulkUpload', 'bulkUpload')->name('property.bulkUpload');
        Route::post('/property/manageBulkUpload', 'manageBulkUpload')->name('property.manageBulkUpload');

    });
});




Route::get('/', function () {
    return view('welcome');
});



