"use strict";



// Class Definition
var base_url="";
var KTAddProperty = function () {

    // Private Variables

    var _wizardEl;

    var _formEl;

    var _wizard;

    var _avatar;

    var validations_info;

    var validations_auction;

    var _wizardE2;

    var _wizard_1;



    // Private Functions

    var _initWizard = function () {

        // Initialize form wizard

        _wizard = new KTWizard(_wizardEl, {

            startStep: 1, // initial active step number

            clickableSteps: true  // allow step clicking

        });



        // Validation before going to next page

        // _wizard.on('beforeNext', function (wizard) {
        // 	_wizard.goNext();
        // 	KTUtil.scrollTop();

        // 	_wizard.stop();  // Don't go to the next step

        // });



        // Change Event

        _wizard.on('change', function (wizard) {

            KTUtil.scrollTop();

        });

    }



    var _initValidations = function () {

        // Init form validation rules. For more info check the FormValidation plugin's official documentation:https://formvalidation.io/



        // Validation Rules For Step 1

        validations_info = FormValidation.formValidation(

            KTUtil.getById('kt_form'),
            {

                fields: {

                    property_name: {

                        validators: {

                            notEmpty: {

                                message: 'Property Title is required'

                            }

                        }

                    },

                    location_id: {

                        validators: {

                            notEmpty: {

                                message: 'Location is required'

                            }

                        }

                    },

                    property_status: {

                        validators: {

                            notEmpty: {

                                message: 'Property Status is required'

                            }

                        }

                    },

                    property_type_id: {

                        validators: {

                            notEmpty: {

                                message: 'Property Type is required'

                            }

                        }

                    },

                    state_id: {

                        validators: {

                            notEmpty: {

                                message: 'State is required'

                            }

                        }

                    },

                    city_id: {

                        validators: {

                            notEmpty: {

                                message: 'City is required'

                            }

                        }

                    },

                    possession: {

                        validators: {

                            notEmpty: {

                                message: 'Possession is required'

                            }

                        }

                    },

                    area: {

                        validators: {

                            notEmpty: {

                                message: 'Area is required'

                            }

                        }

                    },

                    area_unit_id: {

                        validators: {

                            notEmpty: {

                                message: 'Area Unit is required'

                            }

                        }

                    },

                    borrower_id: {

                        validators: {

                            notEmpty: {

                                message: 'Borrower is required'

                            }

                        }

                    },

                    bank_id: {

                        validators: {

                            notEmpty: {

                                message: 'Bank is required'

                            }

                        }

                    },

                    banker_id: {

                        validators: {

                            notEmpty: {

                                message: 'Banker is required'

                            }

                        }

                    },

                    market_amount: {

                        validators: {

                            notEmpty: {

                                message: 'Market Amount is required'

                            }

                        }

                    },

                    ai_amount: {

                        validators: {

                            notEmpty: {

                                message: 'AI Amount is required'

                            }

                        }

                    },

                    address: {

                        validators: {

                            notEmpty: {

                                message: 'Address is required'

                            }

                        }

                    }
                },



                plugins: {

                    trigger: new FormValidation.plugins.Trigger(),

                    bootstrap: new FormValidation.plugins.Bootstrap()

                }

            }

        );

        // Validation Rules For Step 1

        validations_auction = FormValidation.formValidation(

            KTUtil.getById('kt_auction_form'),
            {

                fields: {

                    auction_title: {

                        validators: {

                            notEmpty: {

                                message: 'Auction Title is required'

                            }

                        }

                    },

                    auction_code: {

                        validators: {

                            notEmpty: {

                                message: 'Auction Code is required'

                            }

                        }

                    },

                    auction_date: {

                        validators: {

                            notEmpty: {

                                message: 'Auction Date is required'

                            }

                        }

                    },

                    auction_amount: {

                        validators: {

                            notEmpty: {

                                message: 'Auction Amount is required'

                            }

                        }

                    },

                    emd_amount: {

                        validators: {

                            notEmpty: {

                                message: 'EMD Amount is required'

                            }

                        }

                    }
                },



                plugins: {

                    trigger: new FormValidation.plugins.Trigger(),

                    bootstrap: new FormValidation.plugins.Bootstrap()

                }

            }

        );


    }



    var _initAvatar = function () {

        _avatar = new KTImageInput('kt_user_add_avatar');

    }


    var fp = $('#kt_form');
    var bp = $('#btn_property');

    bp.click(function(e)
    {
        validations_info.validate().then(function(status)
        {
            if (status == 'Valid')
            {
                fp.ajaxForm({
                    beforeSend: function()
                    {
                        bp.attr('disabled', 'disabled');
                    },
                    success: function(e)
                    {
                        var resp = e.split('::');
                        bp.removeAttr('disabled');

                        if(resp[0]==200)
                        {
                            Swal.fire({
                                text: resp[1],
                                icon: "success",
                                buttonsStyling: false,
                                confirmButtonText: "Ok, got it!",
                                customClass: {
                                    confirmButton: "btn font-weight-bold btn-light"
                                }
                            }).then(function() {
                                window.location = 'add?id='+resp[2];

                            });
                        }
                        else
                        {
                            Swal.fire({
                                text: resp[1],
                                icon: "error",
                                buttonsStyling: false,
                                confirmButtonText: "Ok, got it!",
                                customClass: {
                                    confirmButton: "btn font-weight-bold btn-light"
                                }
                            }).then(function() {
                                KTUtil.scrollTop();
                            });
                        }

                    },
                    error: function(e)
                    {
                        Swal.fire({
                            text: "Something went wrong, please try again",
                            icon: "error",
                            buttonsStyling: false,
                            confirmButtonText: "Ok, got it!",
                            customClass: {
                                confirmButton: "btn font-weight-bold btn-light"
                            }
                        });
                        bp.removeAttr('disabled');
                    }
                });
            }
            else
            {
                e.preventDefault();

                Swal.fire({

                    text: "Sorry, looks like there are some errors detected, please try again.",

                    icon: "error",

                    buttonsStyling: false,

                    confirmButtonText: "Ok, got it!",

                    customClass: {

                        confirmButton: "btn font-weight-bold btn-light"

                    }

                }).then(function() {

                    KTUtil.scrollTop();

                });

                return false;

            }
        });
    });



    var fg = $('#kt_galleryform');
    var bg = $('#btn_gallery');

    bg.click(function(e)
    {
        fg.ajaxForm({

            beforeSend: function()
            {
                bg.attr('disabled', 'disabled');
            },
            success: function(e)
            {
                var resp = e.split('::');
                bg.removeAttr('disabled');

                if(resp[0]==200)
                {
                    Swal.fire({
                        text: resp[1],
                        icon: "success",
                        buttonsStyling: false,
                        confirmButtonText: "Ok, got it!",
                        customClass: {
                            confirmButton: "btn font-weight-bold btn-light"
                        }
                    }).then(function() {
                        window.location = 'add?id='+resp[2];

                    });
                }
                else
                {
                    Swal.fire({
                        text: resp[1],
                        icon: "error",
                        buttonsStyling: false,
                        confirmButtonText: "Ok, got it!",
                        customClass: {
                            confirmButton: "btn font-weight-bold btn-light"
                        }
                    }).then(function() {
                        KTUtil.scrollTop();
                    });
                }

            },
            error: function(e)
            {
                Swal.fire({
                    text: "Something went wrong, please try again",
                    icon: "error",
                    buttonsStyling: false,
                    confirmButtonText: "Ok, got it!",
                    customClass: {
                        confirmButton: "btn font-weight-bold btn-light"
                    }
                });
                bg.removeAttr('disabled');
            }
        });
    });


    var fa = $('#kt_auction_form');
    var ba = $('#btn_auction');

    ba.click(function(e)
    {
        validations_auction.validate().then(function(status)
        {
            if (status == 'Valid')
            {
                fa.ajaxForm({
                    beforeSend: function()
                    {
                        ba.attr('disabled', 'disabled');
                    },
                    success: function(e)
                    {
                        var resp = e.split('::');
                        ba.removeAttr('disabled');

                        if(resp[0]==200)
                        {
                            Swal.fire({
                                text: resp[1],
                                icon: "success",
                                buttonsStyling: false,
                                confirmButtonText: "Ok, got it!",
                                customClass: {
                                    confirmButton: "btn font-weight-bold btn-light"
                                }
                            }).then(function() {
                                window.location = 'add?id='+resp[2];

                            });
                        }
                        else
                        {
                            Swal.fire({
                                text: resp[1],
                                icon: "error",
                                buttonsStyling: false,
                                confirmButtonText: "Ok, got it!",
                                customClass: {
                                    confirmButton: "btn font-weight-bold btn-light"
                                }
                            }).then(function() {
                                KTUtil.scrollTop();
                            });
                        }

                    },
                    error: function(e)
                    {
                        Swal.fire({
                            text: "Something went wrong, please try again",
                            icon: "error",
                            buttonsStyling: false,
                            confirmButtonText: "Ok, got it!",
                            customClass: {
                                confirmButton: "btn font-weight-bold btn-light"
                            }
                        });
                        ba.removeAttr('disabled');
                    }
                });
            }
            else
            {
                e.preventDefault();

                Swal.fire({

                    text: "Sorry, looks like there are some errors detected, please try again.",

                    icon: "error",

                    buttonsStyling: false,

                    confirmButtonText: "Ok, got it!",

                    customClass: {

                        confirmButton: "btn font-weight-bold btn-light"

                    }

                }).then(function() {

                    KTUtil.scrollTop();

                });

                return false;

            }
        });
    });

    return {

        // public functions

        init: function () {

            _wizardEl = KTUtil.getById('kt_wizard');
            _wizardE2 = KTUtil.getById('kt_wizard_2');

            _formEl = KTUtil.getById('kt_form');



            _initWizard();

            _initValidations();

            _initAvatar();

        }

    };



}();

var KTTypeahead = function() {

    var demo2 = function() {
        // constructs the suggestion engine
        var userSource = new Bloodhound({
            datumTokenizer: Bloodhound.tokenizers.whitespace,
            queryTokenizer: Bloodhound.tokenizers.whitespace,
            // `states` is an array of state names defined in "The Basics"
            remote: {
                url: 'getShelfAutocomplete?query=%QUERY',
                wildcard: '%QUERY'
            }
        });

        userSource.initialize();

        $('#shelf_id').typeahead({
                hint: true,
                highlight: true,
                minLength: 1
            },
            {
                name: 'states',
                source: userSource
            });
    }




    return {
        // public functions
        init: function() {
            demo2();
        }
    };

}();

// Class definition
var KTSelect2 = function() {
    // Private functions
    var select2_demos = function() {
        // basic
        $('#amenities_id').select2({
            placeholder: "Select a amenities",
        });
    }

    // Public functions
    return {
        init: function() {
            select2_demos();
        }
    };
}();

var KTSummernoteDemo = function () {
    // Private functions
    var editor_demos = function () {
        $('.summernote').summernote({
            height: 250,
            tabsize: 2,
            followingToolbar: true,
        });
    }

    return {
        // public functions
        init: function() {
            editor_demos();
        }
    };
}();


var KTBootstrapDatepicker = function () {

    var arrows;
    if (KTUtil.isRTL()) {
        arrows = {
            leftArrow: '<i class="la la-angle-right"></i>',
            rightArrow: '<i class="la la-angle-left"></i>'
        }
    } else {
        arrows = {
            leftArrow: '<i class="la la-angle-left"></i>',
            rightArrow: '<i class="la la-angle-right"></i>'
        }
    }

    // Private functions
    var demos_date = function () {

        // orientation
        $('#auction_date').datepicker({
            rtl: KTUtil.isRTL(),
            orientation: "bottom left",
            todayHighlight: true,
            format: "dd-mm-yyyy",
            templates: arrows,
            autoclose: true
        });
    }

    return {
        // public functions
        init: function() {
            demos_date();
        }
    };
}();

jQuery(document).ready(function () {
    KTAddProperty.init();
    KTSummernoteDemo.init();
    KTBootstrapDatepicker.init();
    $('.delete-media').on('click', function () {
        let id = $(this).data('id');

        var _token = $('#_token').val();
        Swal.fire({
            title: 'Are you sure?',
            text: "This media file will be deleted permanently!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Yes, delete it!',
            cancelButtonText: 'Cancel'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: "deleteMedia",
                    type: "POST",
                    data: {
                        id: id,
                        _token: _token
                    },
                    success: function (response) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Deleted!',
                            text: 'Media has been deleted.',
                            timer: 1500,
                            showConfirmButton: false
                        }).then(() => {
                            location.reload();
                        });
                    },
                    error: function () {
                        Swal.fire('Error', 'Something went wrong!', 'error');
                    }
                });
            }
        });
    });

    $('#deleteSelected').on('click', function() {

        var _token = $('#_token').val();
        let selected = [];
        $('.media-check:checked').each(function() {
            selected.push($(this).val());
        });

        if (selected.length === 0) {
            Swal.fire('No files selected!', '', 'info');
            return;
        }

        Swal.fire({
            title: 'Are you sure?',
            text: "You are about to delete " + selected.length + " media file(s).",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Yes, delete them!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: "deleteMultipleMedia",
                    method: 'POST',
                    data: {
                        _token: _token,
                        ids: selected
                    },
                    success: function(res) {
                        if (res.status === 200) {
                            Swal.fire('Deleted!', res.message, 'success').then(() => {
                                location.reload();
                            });
                        } else {
                            Swal.fire('Error!', 'Something went wrong.', 'error');
                        }
                    }
                });
            }
        });
    });
});
$('#addMoreMedia').click(function () {
    let html = `
            <div class="row media-entry mb-3">
                <div class="col-md-4">
                    <select name="media_type[]" class="form-control">
                        <option value="">Select Media Type</option>
                        <option value="I">Property Images</option>
                        <option value="S">Sales Public notice</option>
                        <option value="P">Poster</option>
                        <option value="W">Whats app draft</option>
                    </select>
                </div>
                <div class="col-md-4">
                    <input type="file" name="media[]" class="form-control" />
                </div>
                <div class="col-md-2">
                    <button type="button" class="btn btn-danger removeMedia">Remove</button>
                </div>
            </div>
        `;
    $('#mediaRepeater').append(html);
});

$(document).on('click', '.removeMedia', function () {
    $(this).closest('.media-entry').remove();
});
