"use strict";



// Class Definition

var KTLogin = function() {

    var _login;



    var _showForm = function(form) {

        var cls = 'login-' + form + '-on';

        var form = 'kt_login_' + form + '_form';



        _login.removeClass('login-forgot-on');

        _login.removeClass('login-signin-on');

        _login.removeClass('login-signup-on');



        _login.addClass(cls);



        KTUtil.animateClass(KTUtil.getById(form), 'animate__animated animate__backInUp');

    }



    var _handleSignInForm = function() {

        var validation;



        // Init form validation rules. For more info check the FormValidation plugin's official documentation:https://formvalidation.io/

        validation = FormValidation.formValidation(

			KTUtil.getById('kt_login_signin_form'),

			{

				fields: {

					username: {

						validators: {

							notEmpty: {

								message: 'Username is required'

							}

						}

					}

					// password: {

					// 	validators: {

					// 		notEmpty: {

					// 			message: 'Password is required'

					// 		}

					// 	}

					// }

				},

				plugins: {

                    trigger: new FormValidation.plugins.Trigger(),

                    submitButton: new FormValidation.plugins.SubmitButton(),

                    //defaultSubmit: new FormValidation.plugins.DefaultSubmit(), // Uncomment this line to enable normal button submit after form validation

					bootstrap: new FormValidation.plugins.Bootstrap()

				}

			}

		);



        $('#kt_login_signin_submit').on('click', function (e) {

            e.preventDefault();



            validation.validate().then(function(status) {

		        if (status == 'Valid')

                {

                    $.ajax({

                        url:'login',

                        type:'POST',

                        data:'username='+$('#username').val()+'&password='+$('#password').val()+'&_token='+$('#_token').val(),

                        success:function(data)

                        {

                            var resp = data.split('::');



                            if(resp[0]!=200)

                            {

                                swal.fire({

                                    text: resp[1],

                                    icon: "error",

                                    buttonsStyling: false,

                                    confirmButtonText: "Ok, got it!",

                                    customClass: {

                                        confirmButton: "btn font-weight-bold btn-light-primary"

                                    }

                                }).then(function() {

                                    if(resp[0]==302)
                                    {
                                        $('#otp_user_id').val(resp[2]);
                                        $('#otp_modal').modal('show');
                                    }

                                });

                            }

                            else

                            {

                                window.location = 'index';

                            }

                        }

                    })



				} else {

					swal.fire({

		                text: "Please enter username & password",

		                icon: "error",

		                buttonsStyling: false,

		                confirmButtonText: "Ok, got it!",

                        customClass: {

    						confirmButton: "btn font-weight-bold btn-light-primary"

    					}

		            }).then(function() {

						KTUtil.scrollTop();

					});

				}

		    });

        });



        // Handle forgot button

        $('#kt_login_forgot').on('click', function (e) {

            e.preventDefault();

            _showForm('forgot');

        });



        // Handle signup

        $('#kt_login_signup').on('click', function (e) {

            e.preventDefault();

            _showForm('signup');

        });

    }



    var _handleForgotForm = function(e) {

        var validation;



        // Init form validation rules. For more info check the FormValidation plugin's official documentation:https://formvalidation.io/

        validation = FormValidation.formValidation(

			KTUtil.getById('kt_login_forgot_form'),

			{

				fields: {

					email: {

						validators: {

							notEmpty: {

								message: 'Email address is required'

							},

                            emailAddress: {

								message: 'The value is not a valid email address'

							}

						}

					}

				},

				plugins: {

					trigger: new FormValidation.plugins.Trigger(),

					bootstrap: new FormValidation.plugins.Bootstrap()

				}

			}

		);



        // Handle submit button

        $('#kt_login_forgot_submit').on('click', function (e) {

            e.preventDefault();



            validation.validate().then(function(status) {

		        if (status == 'Valid') {

                    // Submit form

                    KTUtil.scrollTop();

				} else {

					swal.fire({

		                text: "Sorry, looks like there are some errors detected, please try again.",

		                icon: "error",

		                buttonsStyling: false,

		                confirmButtonText: "Ok, got it!",

                        customClass: {

    						confirmButton: "btn font-weight-bold btn-light-primary"

    					}

		            }).then(function() {

						KTUtil.scrollTop();

					});

				}

		    });

        });



        // Handle cancel button

        $('#kt_login_forgot_cancel').on('click', function (e) {

            e.preventDefault();



            _showForm('signin');

        });

    }



    // Public Functions

    return {

        // public functions

        init: function() {

            _login = $('#kt_login');



            _handleSignInForm();

            _handleSignUpForm();

            _handleForgotForm();

        }

    };

}();



// Class Initialization

jQuery(document).ready(function() {

    KTLogin.init();

});

function varifyOtp()
{
    var otp = $('#otp').val();
    var otp_user_id = $('#otp_user_id').val();

    $.ajax({
        url:'varifyOtp',
        type:'POST',
        data:'otp='+otp+'&otp_user_id='+otp_user_id,
        success:function(data)
        {
            var resp = data.split('::');

            if(resp[0]!=200)
            {
               swal.fire({

                    text: resp[1],

                    icon: "error",

                    buttonsStyling: false,

                    confirmButtonText: "Ok, got it!",

                    customClass: {

                        confirmButton: "btn font-weight-bold btn-light-primary"

                    }

                }).then(function() {

                    KTUtil.scrollTop();

                });
            }
            else
            {
                window.location = 'index';
            }
        }
    })
}

