<?php

namespace App\Http\Controllers;

 use App\Models\MenuModel;

 class Controller
{
     public static function getMenus()
     {
         $role_id = session('role_id', '0');
         $menu_query = MenuModel::where('parent_id', 0)
             ->where('menu_type', 'C')
             ->where('is_show', 'Y')
             ->where('active_status', 'S')
             ->where('status', '1')
             ->orderBy('sort_order', 'asc');


         $menu_query->whereRaw('? = ANY(string_to_array(role_id, \',\'))', [$role_id]);

         $menu_data = $menu_query->get()->toArray();
         $resp = [];

         foreach ($menu_data as $i => $val) {
             $sub_menu = MenuModel::where('parent_id', $val['menu_id'])
                 ->where('menu_type', 'C')
                 ->where('is_show', 'Y')
                 ->where('active_status', 'S')
                 ->where('status', '1')
                 ->whereRaw('? = ANY(string_to_array(role_id, \',\'))', [$role_id])
                 ->orderBy('sort_order', 'asc')
                 ->get()
                 ->toArray();

             $resp[$i] = [
                 'menu' => $val['menu'],
                 'title' => $val['menu_alias'],
                 'controller' => str_replace('Controller', '', $val['menu_controller']),
                 'action' => $val['menu_action'],
                 'icon' => $val['menu_icon'],
                 'child_menus' => $val['child_menus'],
             ];

             if (!empty($sub_menu)) {
                 foreach ($sub_menu as $j => $sub_val) {
                     $sub_sub_menu = MenuModel::where([
                         ['parent_id', '=', $sub_val['menu_id']],
                         ['menu_type', '=', 'C'],
                         ['is_show', '=', 'Y'],
                         ['active_status', '=', 'S'],
                         ['status', '=', '1'],
                     ])
                         ->orderBy('sort_order', 'asc')
                         ->get()
                         ->toArray();

                     $resp[$i]['submenu'][$j] = [
                         'menu' => $sub_val['menu'],
                         'title' => $sub_val['menu_alias'],
                         'controller' => str_replace('Controller', '', $sub_val['menu_controller']),
                         'action' => $sub_val['menu_action'],
                         'icon' => $sub_val['menu_icon'],
                         'child_menus' => $sub_val['child_menus'],
                     ];

                     if (!empty($sub_sub_menu)) {
                         foreach ($sub_sub_menu as $k => $sub_sub_val) {
                             $resp[$i]['submenu'][$j]['subsubmenu'][$k] = [
                                 'menu' => $sub_sub_val['menu'],
                                 'title' => $sub_sub_val['menu_alias'],
                                 'controller' => str_replace('Controller', '', $sub_sub_val['menu_controller']),
                                 'action' => $sub_sub_val['menu_action'],
                                 'icon' => $sub_sub_val['menu_icon'],
                                 'child_menus' => $sub_sub_val['child_menus'],
                             ];
                         }
                     }
                 }
             }
         }


         view()->share('menu', $resp);
         return $resp;
     }
 }
