@extends('console::layouts.main')

@php
    $baseUrl = asset('public/themes/consoleTheme');
@endphp

@section('content')
    <!--begin::Content-->
    <div class="content d-flex flex-column flex-column-fluid" id="kt_content">

        <!--begin::Entry-->
        <div class="d-flex flex-column-fluid">
            <!--begin::Container-->
            <div class="container">
                <!--begin::Card-->
                <div class="card card-custom card-transparent">
                    <div class="card-body p-0">
                        <!--begin::Wizard-->
                        <div class="wizard wizard-4" id="kt_wizard" data-wizard-state="step-first" data-wizard-clickable="true">
                            <!--begin::Wizard Nav-->
                            <div class="wizard-nav">
                                <div class="wizard-steps">
                                    <div class="wizard-step" data-wizard-type="step" data-wizard-state="current">
                                        <div class="wizard-wrapper">
                                            <div class="wizard-number">1</div>
                                            <div class="wizard-label">
                                                <div class="wizard-title">Property Info</div>
                                                <div class="wizard-desc">Property Info</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="wizard-step" data-wizard-type="step">
                                        <div class="wizard-wrapper">
                                            <div class="wizard-number">2</div>
                                            <div class="wizard-label">
                                                <div class="wizard-title">Gallery</div>
                                                <div class="wizard-desc">Gallery</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="wizard-step" data-wizard-type="step">
                                        <div class="wizard-wrapper">
                                            <div class="wizard-number">3</div>
                                            <div class="wizard-label">
                                                <div class="wizard-title">Auction</div>
                                                <div class="wizard-desc">Auction</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="wizard-step" data-wizard-type="step">
                                    </div>
                                </div>
                            </div>
                            <!--end::Wizard Nav-->
                            <!--begin::Card-->
                            <div class="card card-custom card-shadowless rounded-top-0">
                                <!--begin::Body-->
                                <div class="card-body p-0">
                                    <div class="row justify-content-center py-8 px-8 py-lg-15 px-lg-10">
                                        <div class="col-xl-12 col-xxl-10">
                                            <!--begin::Wizard Form-->
                                            <div class="row justify-content-center">
                                                <div class="col-xl-12">
                                                    <!--begin::Wizard Step 1-->
                                                    <div class="my-5 step" data-wizard-type="step-content" data-wizard-state="current">
                                                        <form class="form" id="kt_form" method="POST" action="<?php echo url(''); ?>/console/property/manageData" enctype="multipart/form-data">

                                                            <!--begin::Group-->
                                                            <div class="form-group row">

                                                                <div class="col-md-12 col-xl-12 col-xs-12 col-lg-12">
                                                                    <h5 class="text-dark font-weight-bold mb-10 product_Variations">Property Information:</h5>
                                                                    <button type="submit" id="btn_property" class="btn btn-primary font-weight-bolder px-9 py-4 float-right">Save</button>

                                                                </div>
                                                                <label>&nbsp;</label>

                                                                <span class="form-text text-muted"></span>
                                                            </div>
                                                            <div class="form-group row">
                                                                <div class="col-lg-4">
                                                                    <label>Title:</label>
                                                                    <input type="hidden" class="form-control" name="property_id" id="property_id" value="<?php echo (!empty($_REQUEST['id']))?$_REQUEST['id']:''; ?>" />
                                                                    <input type="hidden" name="property_section" value="I">

                                                                    <input type="hidden" id="_token" name="_token" value="{{ csrf_token() }}"/>
                                                                    <input type="text" class="form-control" placeholder="Enter Property Title" name="property_name" id="property_name" value="<?php echo (!empty($property_data['property_name']))?$property_data['property_name']:''; ?>"/>
                                                                    <!-- <span class="form-text text-muted">Please enter product title</span> -->
                                                                </div>
                                                                <div class="col-lg-4">
                                                                    <label>Property Status:</label>
                                                                    <select class="form-control" name="property_status" id="property_status">
                                                                        <option value="">--Property Status--</option>
                                                                        <option value="A" <?php if(!empty($property_data['property_status']) && $property_data['property_status']=="A"){ ?> selected="selected" <?php } ?>>Available</option>
                                                                        <option value="H" <?php if(!empty($property_data['property_status']) && $property_data['property_status']=="H"){ ?> selected="selected" <?php } ?>>Hold</option>
                                                                        <option value="S" <?php if(!empty($property_data['property_status']) && $property_data['property_status']=="S"){ ?> selected="selected" <?php } ?>>Sold</option>

                                                                    </select>
                                                                </div>
                                                                <div class="col-lg-4">
                                                                    <label>Property Type:</label>
                                                                    <select class="form-control" name="property_type_id" id="property_type_id"  >
                                                                        <option value="">--Property Type--</option>
                                                                        <?php
                                                                        if(!empty($property_type_data))
                                                                        {
                                                                        foreach($property_type_data as $property_type_val)
                                                                        {
                                                                            ?>
                                                                        <option value="<?php echo (!empty($property_type_val['property_type_id']))?$property_type_val['property_type_id']:''; ?>" <?php if(!empty($property_data['property_type_id']) && $property_data['property_type_id']==$property_type_val['property_type_id']){ ?> selected="selected" <?php } ?>><?php echo $property_type_val['property_type_name']; ?></option>
                                                                            <?php
                                                                        }
                                                                        }
                                                                        ?>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                            <div class="form-group row">
                                                                <div class="col-lg-4">
                                                                    <label>State:</label>

                                                                    <select class="form-control" name="state_id" id="state_id"  onchange="getCity(this);">
                                                                        <option value="">--State--</option>
                                                                        <?php
                                                                        if(!empty($state_data))
                                                                        {
                                                                        foreach($state_data as $state_val)
                                                                        {
                                                                            ?>
                                                                        <option value="<?php echo (!empty($state_val['state_id']))?$state_val['state_id']:''; ?>" <?php if(!empty($property_data['state_id']) && $property_data['state_id']==$state_val['state_id']){ ?> selected="selected" <?php } ?>><?php echo $state_val['state_name']; ?></option>
                                                                            <?php
                                                                        }
                                                                        }
                                                                        ?>
                                                                    </select>
                                                                </div>
                                                                <div class="col-lg-4">
                                                                    <label>City:</label>

                                                                    <select class="form-control" name="city_id" id="city_id"  onchange="getLocation(this);">
                                                                        <option value="">--City--</option>
                                                                        <?php
                                                                        if(!empty($city_data))
                                                                        {
                                                                        foreach($city_data as $city_val)
                                                                        {
                                                                            ?>
                                                                        <option value="<?php echo (!empty($city_val['city_id']))?$city_val['city_id']:''; ?>" <?php if(!empty($property_data['city_id']) && $property_data['city_id']==$city_val['city_id']){ ?> selected="selected" <?php } ?>><?php echo $city_val['city_name']; ?></option>
                                                                            <?php
                                                                        }
                                                                        }
                                                                        ?>
                                                                    </select>
                                                                </div>
                                                                <div class="col-lg-4">
                                                                    <label>Location:</label>

                                                                    <select class="form-control" name="location_id" id="location_id">
                                                                        <option value="">--Location--</option>
                                                                        <?php
                                                                        if(!empty($location_data))
                                                                        {
                                                                        foreach($location_data as $location_val)
                                                                        {
                                                                            ?>
                                                                        <option value="<?php echo (!empty($location_val['location_id']))?$location_val['location_id']:''; ?>" <?php if(!empty($property_data['location_id']) && $property_data['location_id']==$location_val['location_id']){ ?> selected="selected" <?php } ?>><?php echo $location_val['location_name']; ?></option>
                                                                            <?php
                                                                        }
                                                                        }
                                                                        ?>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                            <div class="form-group row">
                                                                <div class="col-lg-4">

                                                                    <label>Possession:</label>
                                                                    <select class="form-control" name="possession" id="possession">
                                                                        <option value="">--Possession--</option>
                                                                        <option value="P" <?php if(!empty($property_data['possession']) && $property_data['possession']=="P"){ ?> selected="selected" <?php } ?>>Physical</option>
                                                                        <option value="S" <?php if(!empty($property_data['possession']) && $property_data['possession']=="S"){ ?> selected="selected" <?php } ?>>Symbolic</option>

                                                                    </select>
                                                                </div>
                                                                <div class="col-lg-4">
                                                                    <label>Area:</label>
                                                                    <input type="text" class="form-control" placeholder="Enter Area" name="area" id="area" value="<?php echo (!empty($property_data['area']))?$property_data['area']:''; ?>"  />

                                                                </div>
                                                                <div class="col-lg-4">
                                                                    <label>Area Unit:</label>
                                                                    <select class="form-control" name="area_unit_id" id="area_unit_id"  >
                                                                        <option value="">--Area Unit--</option>
                                                                        <?php
                                                                        if(!empty($area_unit_data))
                                                                        {
                                                                        foreach($area_unit_data as $area_unit_val)
                                                                        {
                                                                            ?>
                                                                        <option value="<?php echo (!empty($area_unit_val['area_unit_id']))?$area_unit_val['area_unit_id']:''; ?>" <?php if(!empty($property_data['area_unit_id']) && $property_data['area_unit_id']==$area_unit_val['area_unit_id']){ ?> selected="selected" <?php } ?>><?php echo $area_unit_val['unit_short_name']; ?></option>
                                                                            <?php
                                                                        }
                                                                        }
                                                                        ?>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                            <div class="form-group row">
                                                                <div class="col-lg-4">
                                                                    <label>Borrower:</label>
                                                                    <select class="form-control" name="borrower_id" id="borrower_id"  >
                                                                        <option value="">--Borrower--</option>
                                                                        <?php
                                                                        if(!empty($borrower_data))
                                                                        {
                                                                        foreach($borrower_data as $borrower_val)
                                                                        {
                                                                            ?>
                                                                        <option value="<?php echo (!empty($borrower_val['borrower_id']))?$borrower_val['borrower_id']:''; ?>" <?php if(!empty($property_data['borrower_id']) && $property_data['borrower_id']==$borrower_val['borrower_id']){ ?> selected="selected" <?php } ?>><?php echo $borrower_val['borrower_name']; ?></option>
                                                                            <?php
                                                                        }
                                                                        }
                                                                        ?>
                                                                    </select>
                                                                </div>
                                                                <div class="col-lg-4">
                                                                    <label>Bank:</label>
                                                                    <select class="form-control" name="bank_id" id="bank_id"  onchange="getBanker(this);" >
                                                                        <option value="">--Bank--</option>
                                                                        <?php
                                                                        if(!empty($bank_data))
                                                                        {
                                                                        foreach($bank_data as $bank_val)
                                                                        {
                                                                            ?>
                                                                        <option value="<?php echo (!empty($bank_val['bank_id']))?$bank_val['bank_id']:''; ?>" <?php if(!empty($property_data['bank_id']) && $property_data['bank_id']==$bank_val['bank_id']){ ?> selected="selected" <?php } ?>><?php echo $bank_val['bank_name']; ?></option>
                                                                            <?php
                                                                        }
                                                                        }
                                                                        ?>
                                                                    </select>
                                                                </div>
                                                                <div class="col-lg-4">
                                                                    <label>Banker Name:</label>
                                                                    <select class="form-control" name="banker_id" id="banker_id"  >
                                                                        <option value="">--Banker--</option>
                                                                        <?php
                                                                        if(!empty($banker_data))
                                                                        {
                                                                        foreach($banker_data as $banker_val)
                                                                        {
                                                                            ?>
                                                                        <option value="<?php echo (!empty($banker_val['banker_id']))?$banker_val['banker_id']:''; ?>" <?php if(!empty($property_data['banker_id']) && $property_data['banker_id']==$banker_val['banker_id']){ ?> selected="selected" <?php } ?>><?php echo $banker_val['name']; ?></option>
                                                                            <?php
                                                                        }
                                                                        }
                                                                        ?>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                            <div class="form-group row">
                                                                <div class="col-lg-4">
                                                                    <label>Market Amount:</label>
                                                                    <input type="text" class="form-control" placeholder="Enter Market Amount" name="market_amount" id="market_amount" value="<?php echo (!empty($property_data['market_amount']))?$property_data['market_amount']:''; ?>"  />

                                                                </div>
                                                                <div class="col-lg-4">
                                                                    <label>AI Amount:</label>
                                                                    <input type="text" class="form-control" placeholder="Enter AI Amount" name="ai_amount" id="ai_amount" value="<?php echo (!empty($property_data['ai_amount']))?$property_data['ai_amount']:''; ?>"  />

                                                                </div>
                                                                <div class="col-lg-4">
                                                                    <label>Save Amount:</label>
                                                                    <input type="text" class="form-control" placeholder="Enter Save Amount" name="save_amount" id="save_amount" value="<?php echo (!empty($property_data['save_amount']))?$property_data['save_amount']:''; ?>"  />

                                                                </div>
                                                            </div>
                                                            <div class="form-group row">
                                                                <div class="col-lg-6">
                                                                    <label>Address:</label>
                                                                    <textarea class="form-control" name="address" id="address"><?php echo (!empty($property_data['address']))?$property_data['address']:''; ?></textarea>
                                                                </div>

                                                            </div>


                                                        </form>
                                                    </div>
                                                    <!--end::Wizard Step 1-->

                                                    <!--begin::Wizard Step 2-->
                                                    <div class="my-5 step" data-wizard-type="step-content">

                                                        <form class="form" id="kt_galleryform" method="POST" action="<?php echo url(''); ?>/console/property/manageData" enctype="multipart/form-data">

                                                            <!--begin::Group-->
                                                            <div class="form-group row">

                                                                <div class="col-md-12 col-xl-12 col-xs-12 col-lg-12">
                                                                    <h5 class="text-dark font-weight-bold mb-10 product_Variations">Gallery Information:</h5>
                                                                    <button type="submit" id="btn_gallery" class="btn btn-primary font-weight-bolder px-9 py-4 float-right">Save</button>

                                                                    <input type="hidden" class="form-control" name="property_id" id="property_id" value="<?php echo (!empty($_REQUEST['id']))?$_REQUEST['id']:''; ?>" />
                                                                    <input type="hidden" name="property_section" value="G">

                                                                    <input type="hidden" id="_token" name="_token" value="{{ csrf_token() }}"/>
                                                                </div>
                                                                <label>&nbsp;</label>

                                                                <span class="form-text text-muted"></span>
                                                            </div>
                                                            <div class="form-group">
                                                                <div id="mediaRepeater">
                                                                    <div class="row media-entry mb-3">
                                                                        <div class="col-md-4">
                                                                            <select name="media_type[]" class="form-control">
                                                                                <option value="">Select Media Type</option>
                                                                                <option value="I">Property Images</option>
                                                                                <option value="S">Sales Public notice</option>
                                                                                <option value="P">Poster</option>
                                                                                <option value="W">Whats app draft</option>
                                                                            </select>
                                                                        </div>
                                                                        <div class="col-md-4">
                                                                            <input type="file" name="media[]" class="form-control" />
                                                                        </div>
                                                                        <div class="col-md-2">
                                                                            <button type="button" class="btn btn-danger removeMedia">Remove</button>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <button type="button" id="addMoreMedia" class="btn btn-secondary btn-sm mt-2">+ Add More</button>
                                                            </div>

                                                            @if(!empty($mediaList))
                                                                <div class="table-responsive mt-4">
                                                                    <table class="table table-bordered">
                                                                        <thead>
                                                                        <tr>
                                                                            <th></th>
                                                                            <th>Media Type</th>
                                                                            <th>Preview</th>
                                                                            <th>Action</th>
                                                                        </tr>
                                                                        </thead>
                                                                        <tbody>
                                                                        @foreach($mediaList as $media)
                                                                            <tr>
                                                                                <td><input type="checkbox" class="media-check" value="{{ $media->property_media_id }}"></td>
                                                                                <td>
                                                                                    @switch($media->media_type)
                                                                                        @case('I') Property Image @break
                                                                                        @case('S') Sales Public Notice @break
                                                                                        @case('P') Poster @break
                                                                                        @case('W') WhatsApp Draft @break
                                                                                    @endswitch
                                                                                </td>
                                                                                <td>
                                                                                    <a href="{{ asset('storage/app/public/property_media/' . $media->media) }}" target="_blank" class="btn btn-sm btn-primary">View</a>
                                                                                </td>
                                                                                <td>
                                                                                    <button type="button" class="btn btn-danger btn-sm delete-media" data-id="{{ $media->property_media_id }}">Delete</button>
                                                                                </td>
                                                                            </tr>
                                                                        @endforeach
                                                                        </tbody>
                                                                    </table>
                                                                </div>
                                                                <button type="button" id="deleteSelected" class="btn btn-danger">Delete Selected</button>

                                                            @endif



                                                        </form>

                                                    </div>
                                                    <!--end::Wizard Step 2-->


                                                    <!--begin::Wizard Step 3-->
                                                    <div class="my-5 step" data-wizard-type="step-content">
                                                        <form class="form" id="kt_auction_form" method="POST" action="<?php echo url(''); ?>/console/property/manageData" enctype="multipart/form-data">

                                                            <!--begin::Group-->
                                                            <div class="form-group row">

                                                                <div class="col-md-12 col-xl-12 col-xs-12 col-lg-12">
                                                                    <h5 class="text-dark font-weight-bold mb-10 product_Variations">Auction Information:</h5>
                                                                    <button type="submit" id="btn_auction" class="btn btn-primary font-weight-bolder px-9 py-4 float-right">Save</button>

                                                                </div>
                                                                <label>&nbsp;</label>

                                                                <span class="form-text text-muted"></span>
                                                            </div>
                                                            <div class="form-group row">
                                                                <div class="col-lg-4">
                                                                    <label>Title:</label>
                                                                    <input type="hidden" class="form-control" name="property_id" id="property_id" value="<?php echo (!empty($_REQUEST['id']))?$_REQUEST['id']:''; ?>" />
                                                                    <input type="hidden" class="form-control" name="auction_id" id="auction_id" value="<?php echo (!empty($auction_data['auction_id']))?$auction_data['auction_id']:''; ?>" />
                                                                    <input type="hidden" name="property_section" value="A">

                                                                    <input type="hidden" id="_token" name="_token" value="{{ csrf_token() }}"/>
                                                                    <input type="text" class="form-control" placeholder="Enter Auction Title" name="auction_title" id="auction_title" value="<?php echo (!empty($auction_data['auction_title']))?$auction_data['auction_title']:''; ?>"/>
                                                                    <!-- <span class="form-text text-muted">Please enter product title</span> -->
                                                                </div>
                                                                <div class="col-lg-4">
                                                                    <label>Auction Code:</label>
                                                                    <input type="text" class="form-control" placeholder="Enter Auction Code" name="auction_code" id="auction_code" value="<?php echo (!empty($auction_data['auction_code']))?$auction_data['auction_code']:''; ?>"/>

                                                                </div>
                                                                <div class="col-lg-4">
                                                                    <label>Auction Date:</label>
                                                                    <input type="text" class="form-control" placeholder="Enter Auction Date" name="auction_date" id="auction_date" value="<?php echo (!empty($auction_data['auction_date']))?date('d-m-Y',strtotime($auction_data['auction_date'])):''; ?>"/>

                                                                </div>
                                                            </div>
                                                            <div class="form-group row">
                                                                <div class="col-lg-4">
                                                                    <label>Auction Amount:</label>
                                                                    <input type="text" class="form-control" placeholder="Enter Auction Amount" name="auction_amount" id="auction_amount" value="<?php echo (!empty($auction_data['auction_amount']))?$auction_data['auction_amount']:''; ?>"/>

                                                                </div>
                                                                <div class="col-lg-4">
                                                                    <label>EMD Amount:</label>
                                                                    <input type="text" class="form-control" placeholder="Enter EMD Amount" name="emd_amount" id="emd_amount" value="<?php echo (!empty($auction_data['emd_amount']))?$auction_data['emd_amount']:''; ?>"/>

                                                                </div>
                                                            </div>


                                                        </form>
                                                    </div>
                                                    <!--end::Wizard Step 3-->
                                                </div>
                                            </div>
                                            </form>
                                            <!--end::Wizard Form-->
                                        </div>
                                    </div>
                                </div>
                                <!--end::Body-->
                            </div>
                            <!--end::Card-->
                        </div>
                        <!--end::Wizard-->
                    </div>
                </div>
                <!--end::Card-->
            </div>
            <!--end::Container-->
        </div>
        <!--end::Entry-->
    </div>

    <script type="text/javascript">

        function getBanker(mod)
        {
            var bank_id = $(mod).val();

            $.ajax({
                url:'getBankerData?bank_id='+bank_id,
                type:'GET',
                success:function(data)
                {
                    var resp = data.split('::');

                    if(resp[0]==404)
                    {
                        $('#banker_id').html('');
                        $('#banker_id').html(resp[1]);
                    }
                    else
                    {
                        $('#banker_id').html('');
                        $('#banker_id').html(resp[1]);
                    }
                }
            });
        }

        function getCity(mod)
        {
            var state_id = $(mod).val();

            $.ajax({
                url:'getCityData?state_id='+state_id,
                type:'GET',
                success:function(data)
                {
                    var resp = data.split('::');

                    if(resp[0]==404)
                    {
                        $('#city_id').html('');
                        $('#city_id').html(resp[1]);
                        $('#location_id').html('');
                        $('#location_id').html(resp[1]);
                    }
                    else
                    {
                        $('#city_id').html('');
                        $('#city_id').html(resp[1]);
                        $('#location_id').html('');
                        $('#location_id').html('<option value="">--Location--</option>');
                    }
                }
            });
        }

        function getLocation(mod)
        {
            var city_id = $(mod).val();

            $.ajax({
                url:'getLocationData?city_id='+city_id,
                type:'GET',
                success:function(data)
                {
                    var resp = data.split('::');

                    if(resp[0]==404)
                    {
                        $('#location_id').html('');
                        $('#location_id').html(resp[1]);
                    }
                    else
                    {
                        $('#location_id').html('');
                        $('#location_id').html(resp[1]);
                    }
                }
            });
        }
    </script>
    <!--end::Content-->
@endsection
