@php
    $baseUrl = asset('public/themes/consoleTheme');
@endphp
    <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8" />
    <title>Auctionwale</title>
    <meta name="description" content="Login page example" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />

    <link href="{{ $baseUrl }}/assets/css/pages/login/classic/login-2.css" rel="stylesheet" />
    <link href="{{ $baseUrl }}/assets/plugins/global/plugins.bundle.css" rel="stylesheet" />
    <link href="{{ $baseUrl }}/assets/plugins/custom/prismjs/prismjs.bundle.css" rel="stylesheet" />
    <link href="{{ $baseUrl }}/assets/css/style.bundle.css" rel="stylesheet" />
    <link href="{{ $baseUrl }}/assets/css/themes/layout/header/base/light.css" rel="stylesheet" />
    <link href="{{ $baseUrl }}/assets/css/themes/layout/header/menu/light.css" rel="stylesheet" />
    <link rel="shortcut icon" href="{{ $baseUrl }}/assets/media/logos/favicon.png" />
</head>

<body id="kt_body" class="header-fixed header-mobile-fixed subheader-enabled subheader-fixed aside-enabled aside-fixed aside-minimize-hoverable page-loading">
<div class="d-flex flex-column flex-root">
    {{-- Render Page Content --}}
    @yield('content')
</div>

<script>
    var KTAppSettings = {
        "breakpoints": { "sm":576,"md":768,"lg":992,"xl":1200,"xxl":1200 },
        "colors": {
            "theme": {
                "base": {
                    "white":"#ffffff","primary":"#3699FF","secondary":"#E5EAEE","success":"#1BC5BD",
                    "info":"#8950FC","warning":"#FFA800","danger":"#F64E60","light":"#F3F6F9","dark":"#212121"
                }
            }
        },
        "font-family":"Poppins"
    };
</script>

<script src="{{ $baseUrl }}/assets/plugins/global/plugins.bundle.js"></script>
<script src="{{ $baseUrl }}/assets/plugins/custom/prismjs/prismjs.bundle.js"></script>
<script src="{{ $baseUrl }}/assets/js/scripts.bundle.js"></script>
<script src="{{ $baseUrl }}/assets/js/pages/custom/login/login-general.js"></script>
<script src="{{ $baseUrl }}/assets/js/pages/features/miscellaneous/blockui.js?v=7.0.4"></script>

<script>
    KTApp.blockPage({ overlayColor: '#000000', state: 'warning', size: 'lg' });
    setTimeout(() => { KTApp.unblockPage(); }, 2000);
</script>

{{-- OTP Modal --}}
<div class="modal fade" id="otp_modal" data-backdrop="static" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-sm modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Login OTP</h5>
                <button type="button" class="close" data-dismiss="modal"><i class="ki ki-close"></i></button>
            </div>
            <div class="modal-body" id="otp_content">
                <div class="form-group row">
                    <div class="col-md-12">
                        <label for="otp">OTP:</label>
                        <input type="text" name="otp" id="otp" class="form-control" />
                        <input type="hidden" name="otp_user_id" id="otp_user_id" class="form-control" />
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button class="btn btn-danger" data-dismiss="modal">Close</button>
                <button class="btn btn-primary" onclick="varifyOtp();">Submit</button>
            </div>
        </div>
    </div>
</div>
</body>
</html>
