<?php

namespace Modules\Console\Controllers;

use App\Http\Controllers\Controller;


use App\Models\AreaUnitModel;
use App\Models\AuctionModel;
use App\Models\BankModel;
use App\Models\BankerModel;
use App\Models\BorrowerModel;
use App\Models\CityModel;
use App\Models\DistrictModel;
use App\Models\LocationModel;
use App\Models\PropertyMediaModel;
use App\Models\PropertyModel;
use App\Models\PropertyTypeModel;
use App\Models\StateModel;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Shuchkin\SimpleXLSX;

use Illuminate\Support\Facades\Storage;
use NunoMaduro\Collision\Adapters\Phpunit\State;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Http;
class PropertyController extends Controller

{
    public function list()

    {

        if (!empty($_REQUEST['pagination']['page'])) {

            $model_property = new PropertyModel();

            $start_limit = (($_REQUEST['pagination']['page'] - 1) * $_REQUEST['pagination']['perpage']);

            $end_limit = $_REQUEST['pagination']['perpage'];

            $condition = "tbl_property.status='1'";

            if (empty($_REQUEST['sort']['field'])) {

                $field = 'tbl_property.property_id';

                $sort_order = 'desc';

            } else {

                if ($_REQUEST['sort']['field'] == 'UserCode') {
                    $field = 'user_code';

                }

                $sort_order = $_REQUEST['sort']['sort'];

                if (empty($field) && empty($sort_order)) {

                    $field = 'tbl_property.property_id';

                    $sort_order = 'desc';

                } else {

                    $field = 'tbl_property.property_id';

                    $sort_order = 'desc';


                }

            }

            $model_property = new PropertyModel();


            $property_data = $model_property
                ->join('tbl_borrower','tbl_borrower.borrower_id','=','tbl_property.borrower_id')
                ->join('tbl_location','tbl_location.location_id','=','tbl_property.location_id')
                ->join('tbl_property_type','tbl_property_type.property_type_id','=','tbl_property.property_type_id')
                ->join('tbl_bank','tbl_bank.bank_id','=','tbl_property.bank_id')
                ->join('tbl_banker','tbl_banker.banker_id','=','tbl_property.banker_id')
                ->join('tbl_state','tbl_state.state_id','=','tbl_property.state_id')
                ->join('tbl_city','tbl_city.city_id','=','tbl_property.city_id')
                ->join('tbl_district','tbl_district.district_id','=','tbl_property.district_id')
                ->join('tbl_area_unit','tbl_area_unit.area_unit_id','=','tbl_property.area_unit_id')
                ->selectRaw('tbl_property.*,tbl_state.state_name,tbl_city.city_name,tbl_district.district_name,tbl_area_unit.unit_short_name,tbl_borrower.borrower_name,tbl_location.location_name,tbl_bank.bank_name,tbl_banker.name as banker_name,tbl_property_type.property_type_name,tbl_property.property_id as id,tbl_property.active_status')
                ->whereRaw($condition)
                ->orderBy($field, $sort_order)
                ->offset($start_limit)
                ->limit($end_limit)->get();

//            echo "<pre/>";
//            print_r($property_data);
//            exit;


            if (!($property_data->isEmpty())) {

                $resp = array();

                $per_page = $_REQUEST['pagination']['perpage'];

                $total_data = $model_property->orderBy($field, $sort_order)->whereRaw($condition)->get()->count();

                $total_pages = ceil($total_data / $per_page);

                $all_data = $model_property->select('tbl_property.property_id as id')->whereRaw($condition)->orderBy($field, $sort_order)->get();

                $rowIds = array();

                if ($total_pages == 0) {

                    $total_pages = 1;

                }

                $resp['meta'] = array('page' => $_REQUEST['pagination']['page'], 'pages' => $total_pages, 'perpage' => $per_page, 'total' => $total_data, 'rowIds' => $rowIds, 'sort' => 'asc', 'field' => 'RecordId');


                $i = 1;

                $test = '';

                $property_status=['A'=>'Available','H'=>'Hold','S'=>'Sold'];
                $possession=['P'=>'Physical','S'=>'Symbolic'];

                foreach ($property_data as $key => $val) {

                    $resp['data'][$key]['srno'] = $i;

                    $resp['data'][$key]['Id'] = $val['id'];

                    $resp['data'][$key]['RecordId'] = (($key + 1) + (($_REQUEST['pagination']['page'] - 1) * $_REQUEST['pagination']['perpage']));

                    $resp['data'][$key]['property_name'] = $val['property_name'];

                    $resp['data'][$key]['bank_name'] = $val['bank_name'];

                    $resp['data'][$key]['banker_name'] = $val['banker_name'];

                    $resp['data'][$key]['location_name'] = $val['location_name'];

                    $resp['data'][$key]['state_name'] = $val['state_name'];

                    $resp['data'][$key]['city_name'] = $val['city_name'];

                    $resp['data'][$key]['district_name'] = $val['district_name'];

                    $resp['data'][$key]['property_type_name'] = $val['property_type_name'];

                    $resp['data'][$key]['borrower_name'] = $val['borrower_name'];

                    $resp['data'][$key]['property_status'] = $property_status[$val['property_status']];

                    $resp['data'][$key]['possession'] = $possession[$val['possession']];

                    $resp['data'][$key]['area'] = $val['area'].' '.$val['unit_short_name'];

                    $resp['data'][$key]['market_amount'] = $val['market_amount'];

                    $resp['data'][$key]['ai_amount'] = $val['ai_amount'];

                    $resp['data'][$key]['save_amount'] = $val['save_amount'];

                    $resp['data'][$key]['address'] = $val['address'];

                    $resp['data'][$key]['ActiveStatus'] = $val['active_status'];

                    $resp['data'][$key]['Actions'] = '';

                    $i++;

                }

                echo json_encode($resp);

                exit;

            }

        } else {

            return view('console::property.list');
        }

    }

    public function add()

    {

        $model_property = new PropertyModel();
        $model_location = new LocationModel();
        $model_bank = new BankModel();
        $model_banker = new BankerModel();
        $model_borrower = new BorrowerModel();
        $model_property_type = new PropertyTypeModel();
        $model_state = new StateModel();
        $model_city = new CityModel();
        $model_area_unit = new AreaUnitModel();
        $model_property_media = new PropertyMediaModel();
        $model_auction = new AuctionModel();

        $state_data=$model_state->where('active_status','S')->where('status',1)->get();
        $bank_data=$model_bank->where('active_status','S')->where('status',1)->get();
        $borrower_data=$model_borrower->where('active_status','S')->where('status',1)->get();
        $property_type_data=$model_property_type->where('active_status','S')->where('status',1)->get();
        $area_unit_data=$model_area_unit->where('active_status','S')->where('status',1)->get();

        if (!empty($_REQUEST['id'])) {

            $property_data = $model_property->whereRaw('property_id=' . $_REQUEST['id'])->first();
            $auction_data = $model_auction->whereRaw('property_id=' . $_REQUEST['id'])->first();
            $banker_data=$model_banker->where('active_status','S')->where('status',1)->where('bank_id',$property_data->bank_id)->get();
            $location_data=$model_location->where('active_status','S')->where('status',1)->where('city_id',$property_data->city_id)->get();
            $city_data=$model_city->where('active_status','S')->where('status',1)->where('state_id',$property_data->state_id)->get();
            $mediaList=$model_property_media->where('active_status','S')->where('status',1)->where('property_id',$property_data->property_id)->get();
        } else {
            $property_data = array();
            $auction_data = array();
            $banker_data = array();
            $location_data = array();
            $city_data = array();
            $mediaList = array();
        }

        return view('console::property.add', array('property_data' => $property_data,'auction_data'=>$auction_data,'bank_data' => $bank_data,'banker_data' => $banker_data,'borrower_data' => $borrower_data,'property_type_data' => $property_type_data,'location_data' => $location_data,'state_data' => $state_data,'city_data' => $city_data,'area_unit_data'=>$area_unit_data,'mediaList'=>$mediaList));

    }

    public function manageData(Request $request)
    {
        $admin_id = Session::get('admin_id');
        $section = $request->input('property_section');

        switch ($section) {
            case 'I':
                $property_id = $request->input('property_id');

                // Check if same property already exists
                $duplicateQuery = PropertyModel::where('property_name', 'like', $request->property_name)
                    ->where('location_id', $request->location_id)
                    ->where('status', 1);

                if (!empty($property_id)) {
                    $duplicateQuery->where('property_id', '!=', $property_id);
                }

                if ($duplicateQuery->exists()) {
                    echo "400::Same Property Already Exists";
                    exit;
                }

                // Fetch or create model instance
                $property = !empty($property_id) ? PropertyModel::find($property_id) : new PropertyModel();

                // Set audit fields
                if (empty($property_id)) {
                    $property->added_by = $admin_id;
                    $property->added_on = time();
                }

                $property->updated_by = $admin_id;
                $property->updated_on = time();

                // Fill property data
                $property->property_name = $request->property_name ?? '';
                $property->address = $request->address ?? '';
                $property->property_status = $request->property_status ?? '';
                $property->location_id = $request->location_id ?? null;
                $property->city_id = $request->city_id ?? null;
                $property->state_id = $request->location_id ?? null;

                $location = LocationModel::find($request->location_id);
                $property->district_id = $location ? $location->district_id : null;



                $property->possession = $request->possession ?? '';
                $property->property_type_id = $request->property_type_id ?? null;
                $property->borrower_id = $request->borrower_id ?? null;
                $property->area = $request->area ?? null;
                $property->area_unit_id = $request->area_unit_id ?? null;
                $property->bank_id = $request->bank_id ?? null;
                $property->banker_id = $request->banker_id ?? null;
                $property->market_amount = $request->market_amount ?? null;
                $property->ai_amount = $request->ai_amount ?? null;
                $property->save_amount = $request->save_amount ?? null;

                $property->save();

                echo '200::Property added successfully::' . $property->property_id;
                exit;
            case 'G':
                $property_id = $request->input('property_id');

                if (!$property_id) {
                    echo "400::Property Details Missing";
                    exit;
                }

                if ($request->hasFile('media')) {
                    foreach ($request->file('media') as $index => $file) {
                        if ($file) {
                            $media_type = $request->media_type[$index] ?? 'I';
                            $filename = Str::random(10) . '.' . $file->getClientOriginalExtension();
                            //$path = $file->storeAs('public/property_media', $filename);
                            Storage::disk('public')->putFileAs('property_media', $file, $filename);

                            $media = new PropertyMediaModel();
                            $media->property_id = $property_id;
                            $media->media_type = $media_type;
                            $media->media = $filename;
                            $media->media_url = '';
                            $media->added_on = time();
                            $media->added_by = $admin_id;
                            $media->updated_on = time();
                            $media->updated_by = $admin_id;
                            $media->active_status = 'S';
                            $media->status = '1';
                            $media->save();
                        }
                    }

                    echo "200::Media uploaded successfully::".$property_id;
                    exit;
                } else {
                    echo "400::No media selected";
                    exit;
                }
            case 'A':
                $auction_id = $request->input('auction_id');
                $property_id = $request->input('property_id');

                // Validate essential fields
                if (empty($property_id)) {
                    echo "400::Property ID is required.";
                    exit;
                }

                // Create or update Auction
                $auction = !empty($auction_id)
                    ? AuctionModel::find($auction_id)
                    : new AuctionModel();

                $auction->property_id = $property_id;
                $auction->auction_title = $request->auction_title ?? '';
                $auction->auction_code = $request->auction_code ?? '';
                $auction->auction_amount = $request->auction_amount ?? 0;
                $auction->emd_amount = $request->emd_amount ?? 0;

                // Convert auction_date (dd-mm-yyyy) to Y-m-d
                $auction_date = $request->auction_date;
                if (!empty($auction_date)) {
                    $auction->auction_date = \Carbon\Carbon::createFromFormat('d-m-Y', $auction_date)->format('Y-m-d');
                }

                $admin_id = Session::get('admin_id');
                $auction->updated_by = $admin_id;
                $auction->updated_on = time();

                if (empty($auction_id)) {
                    $auction->added_by = $admin_id;
                    $auction->added_on = time();
                }

                $auction->save();

                echo '200::Auction information saved successfully::' . $auction->auction_id;
                exit;

            default:
                echo "400::Invalid section provided";
                exit;
        }
    }


    public function delete()
    {
        $id = !empty($_REQUEST['id']) ? $_REQUEST['id'] : '';
        $property_data = PropertyModel::where('property_id',$id)->first();
        if (!empty($property_data)) {
            $property_data['status'] = '0';
            $property_data->save();
            AuctionModel::where('property_id', $id)->update(['status' => '0']);
            echo "200::Property Deleted Successfully!";
        } else {
            echo "404::Property data not Found!";
        }
    }

    public function updateStatus(Request $request)
    {
        $id = $request->input('id');
        $status = $request->input('status');

        $property = PropertyModel::find($id);

        if (!$property) {
            echo "404::Record not found";
            exit;
        }

        $property->active_status = $status;
        $property->save();
        AuctionModel::where('property_id', $id)->update(['active_status' => $status]);
        $message = $status === 'S' ? 'Record Activated Successfully' : 'Record In-Activated Successfully';
        echo "200::" . $message;
        exit;
    }

    public function manageBulkOperation(Request $request)
    {
        $action = $request->input('action');
        $ids = explode(",", $request->input('id'));

        $msg = '';
        foreach ($ids as $id) {
            $property = PropertyModel::find($id);
            if (!$property) {
                continue;
            }

            switch ($action) {
                case 'A':
                    $property->active_status = 'S';
                    AuctionModel::where('property_id', $id)->update(['active_status' => 'S']);
                    $msg = 'Record Activated Successfully';
                    break;

                case 'I':
                    $property->active_status = 'H';
                    AuctionModel::where('property_id', $id)->update(['active_status' => 'H']);
                    $msg = 'Record In-Activated Successfully';
                    break;

                case 'D':
                    $property->status = '0';
                    AuctionModel::where('property_id', $id)->update(['status' => '0']);
                    $msg = 'Record Deleted Successfully';
                    break;
            }


            $property->save();
        }

        echo "200::" . $msg;
        exit;
    }


    public function getBankerData(){

        $model_banker = new BankerModel();
        $banker_data = $model_banker->select('tbl_banker.*')
            ->where('bank_id',$_REQUEST['bank_id'])
            ->get();
        if(!empty($banker_data))
        {
            $html = '<option value="">--Banker--</option>';
            foreach($banker_data as $banker)
            {
                $html .= '<option value="'.$banker['banker_id'].'">'.$banker['name'].'</option>';
            }

            echo "200::".$html;
            exit;
        }
        else
        {
            $html = '<option value="">--Banker--</option>';
            echo "404::".$html;
            exit;
        }
    }

    public function getCityData(){

        $model_city = new CityModel();
        $city_data = $model_city->select('tbl_city.*')
            ->where('state_id',$_REQUEST['state_id'])
            ->get();
        if(!empty($city_data))
        {
            $html = '<option value="">--City--</option>';
            foreach($city_data as $city)
            {
                $html .= '<option value="'.$city['city_id'].'">'.$city['city_name'].'</option>';
            }

            echo "200::".$html;
            exit;
        }
        else
        {
            $html = '<option value="">--City--</option>';
            echo "404::".$html;
            exit;
        }
    }

    public function getLocationData(){

        $model_location = new LocationModel();
        $location_data = $model_location->select('tbl_location.*')
            ->where('city_id',$_REQUEST['city_id'])
            ->get();
        if(!empty($location_data))
        {
            $html = '<option value="">--Location--</option>';
            foreach($location_data as $location)
            {
                $html .= '<option value="'.$location['location_id'].'">'.$location['location_name'].'</option>';
            }

            echo "200::".$html;
            exit;
        }
        else
        {
            $html = '<option value="">--Location--</option>';
            echo "404::".$html;
            exit;
        }
    }

    public function deleteMedia(Request $request)
    {
        $id = $request->input('id');
        $media = PropertyMediaModel::find($id);

        if ($media) {
            $file_path = storage_path('app/public/property_media/' . $media->media);
            if (File::exists($file_path)) {
                File::delete($file_path);
            }

            $media->delete();
            return response()->json(['status' => '200']);
        }

        return response()->json(['status' => '404']);
    }

    public function deleteMultipleMedia(Request $request)
    {
        $mediaIds = $request->input('ids');
        $deleted = 0;

        if (!empty($mediaIds)) {
            foreach ($mediaIds as $id) {
                $media = PropertyMediaModel::find($id);
                if ($media) {
                    $filePath = storage_path('app/public/property_media/' . $media->media);
                    if (File::exists($filePath)) {
                        File::delete($filePath);
                    }
                    $media->delete();
                    $deleted++;
                }
            }
        }

        return response()->json(['status' => 200, 'message' => "$deleted file(s) deleted successfully."]);
    }

    public function bulkUpload()

    {

        return view('console::property.bulkUpload');

    }

    public function manageBulkUpload(Request $request)
    {
        $admin_id = Session::get('admin_id');
        if (!$request->hasFile('file')) {
            echo "400::File not uploaded";
            exit;
        }

        $path = $request->file('file')->getRealPath();
        $xlsx = SimpleXLSX::parse($path);

        if (!$xlsx) {

            echo "400::Invalid File";
            exit;
        }

        $rows = $xlsx->rows();
        unset($rows[0]); // skip header
//        echo "<pre/>";
//        print_r($rows);
//        exit;

        foreach ($rows as $row) {
            [$auction_code, $auction_title, $property_status, $address, $state_name, $location_name,$district_name, $possession, $property_type, $borrower_name, $area, $area_unit_name,$img_I,$img_S, $bank_name, $banker_name, $banker_mobile, $banker_email, , , , $auction_date,$auction_amount, $emd_amount, $market_amount, $ai_amount, $save_amount, , $img_P, $img_W] = array_pad($row, 30, null); // ensure index safety

            if (AuctionModel::where('auction_code', $auction_code)->exists()) {
                continue;
            }

            // Insert/Find master records
            $state = StateModel::firstOrCreate(['state_name' => $state_name]);
            $district = DistrictModel::firstOrCreate(['district_name' => $district_name]);
            $locationParts = array_map('trim', explode(',', $location_name));
            $locationText = $locationParts[0] ?? '';
            $cityText = $locationParts[1] ?? $locationText;


            $city = CityModel::firstOrCreate([
                'city_name' => $cityText,
                'state_id' => $state->state_id
            ]);

            $location = LocationModel::firstOrCreate([
                'location_name' => $locationText,
                'state_id' => $state->state_id,
                'city_id' => $city->city_id,
                'district_id' => $district->district_id,
            ]);

            $borrower = BorrowerModel::firstOrCreate(['borrower_name' => $borrower_name]);
            $bank = BankModel::firstOrCreate(['bank_name' => $bank_name]);
            $banker = BankerModel::firstOrCreate([
                'bank_id' => $bank->bank_id,
                'name' => $banker_name,
                'mobile_no' => $banker_mobile,
                'email_id' => $banker_email
            ]);
            $area_unit = AreaUnitModel::firstOrCreate(['unit_short_name' => $area_unit_name]);
            $ptype = PropertyTypeModel::firstOrCreate(['property_type_name' => $property_type]);

            $statusMap = ['Available' => 'A', 'Hold' => 'H', 'Sold' => 'S'];
            $possessionMap = ['Physical' => 'P', 'Symbolic' => 'S'];

            $property_status = $statusMap[$property_status] ?? 'A';  // Default to 'A'
            $possession = $possessionMap[$possession] ?? 'P';         // Default to 'P'
            $auction_date=(!empty($auction_date))?date('Y-m-d',strtotime($auction_date)):'';
            // Insert Property
            $property = PropertyModel::create([
                'property_name' => $auction_title,
                'property_status' => $property_status,
                'address' => $address,
                'state_id' => $state->state_id,
                'city_id' => $city->city_id,
                'district_id' => $district->district_id,
                'location_id' => $location->location_id,
                'possession' => $possession,
                'property_type_id' => $ptype->property_type_id,
                'borrower_id' => $borrower->borrower_id,
                'area' => $area,
                'area_unit_id' => $area_unit->area_unit_id,
                'bank_id' => $bank->bank_id,
                'banker_id' => $banker->banker_id,
                'market_amount' => $market_amount,
                'ai_amount' => $ai_amount,
                'save_amount' => $save_amount,
                'added_on' => time(),
                'updated_on' => time(),
                'added_by' => $admin_id,
                'updated_by' => $admin_id,
                'status' => '1',
                'active_status' => 'S',
            ]);

            // Insert Auction
            AuctionModel::create([
                'property_id' => $property->property_id,
                'auction_code' => $auction_code,
                'auction_title' => $auction_title,
                'auction_date' => $auction_date,
                'auction_amount' => $auction_amount,
                'emd_amount' => $emd_amount,
                'status' => '1',
                'active_status' => 'S',
                'added_on' => time(),
                'updated_on' => time(),
                'added_by' => $admin_id,
                'updated_by' => $admin_id,
            ]);

            // Upload media files
            $mediaLinks = [
                'I' => $img_I,
                'S' => $img_S,
                'P' => $img_P,
                'W' => $img_W,
            ];
            foreach ($mediaLinks as $type => $url) {
                if (!empty($url)) {
                    $ext = pathinfo($url, PATHINFO_EXTENSION);
                    $filename = Str::random(10) . '.' . $ext;
                    $relativePath = "property_media/$filename";

                    $response = Http::withHeaders([
                        'User-Agent' => 'Mozilla/5.0'
                    ])->get($url);

                    if ($response->ok()) {
                        Storage::disk('public')->put($relativePath, $response->body());

                        PropertyMediaModel::create([
                            'property_id' => $property->property_id,
                            'media_type' => $type,
                            'media' => $filename,
                            'media_url' => $url,
                            'added_on' => time(),
                            'active_status' => 'S',
                            'status' => '1'
                        ]);
                    }
                }
            }
        }

        echo "200::Bulk upload completed successfully";
        exit;
    }


}
